<!DOCTYPE html>
<html lang="en">
<head>
    
    
      
    
    
    
    
    
    
    
    
    
    
    
    
    
    
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <meta name="description" content="Interactive Math Quiz for all age groups - Play & Learn!" />
  <meta name="keywords" content="Math Quiz, Age Group Quiz, Play and Learn, Free Quiz Game" />
  <meta name="author" content="Your Name" />
  <link rel="icon" href="https://cdn-icons-png.flaticon.com/512/471/471664.png" />
  <title>Math Quiz</title>
  <style>
    * {
      box-sizing: border-box;
      margin: 0;
      padding: 0;
    }
    html {
      scroll-behavior: smooth;
    }
    body {
      font-family: 'Segoe UI', sans-serif;
      background: linear-gradient(135deg, #000428, #004e92);
      background-size: 400% 400%;
      animation: gradientBG 15s ease infinite;
      color: #fff;
      padding-top: 80px;
      overflow-x: hidden;
    }
    @keyframes gradientBG {
      0% { background-position: 0% 50%; }
      50% { background-position: 100% 50%; }
      100% { background-position: 0% 50%; }
    }

    header {
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      background: rgba(0, 0, 0, 0.85);
      backdrop-filter: blur(10px);
      padding: 15px 20px;
      display: flex;
      justify-content: center;
      align-items: center;
      box-shadow: 0 8px 20px rgba(0,0,0,0.4);
      z-index: 1000;
    }
    header h1 {
      color: #ffe066;
      font-size: 26px;
      font-weight: 700;
      letter-spacing: 1px;
    }

    .container {
      max-width: 800px;
      margin: 0 auto;
      padding: 30px;
      animation: fadeIn 1s ease-in-out;
    }
    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(30px); }
      to { opacity: 1; transform: translateY(0); }
    }
    h2, p {
      text-align: center;
      margin-bottom: 20px;
    }

    .age-box {
      background: rgba(255, 255, 255, 0.05);
      border: 1px solid #ffe066;
      box-shadow: 0 4px 20px rgba(255, 255, 255, 0.1);
      border-radius: 16px;
      padding: 30px;
      margin-bottom: 50px;
      backdrop-filter: blur(6px);
    }

    .buttons {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(160px, 1fr));
      gap: 20px;
    }
    .btn {
      padding: 15px;
      border-radius: 14px;
      font-weight: bold;
      text-align: center;
      text-decoration: none;
      transition: transform 0.3s ease, box-shadow 0.3s ease;
      box-shadow: 0 0 12px rgba(255,255,255,0.1);
    }
    .btn:focus-visible {
      outline: 2px solid #fff;
      outline-offset: 4px;
    }
    .btn:hover {
      transform: scale(1.07);
    }
    .age13 {
      background: linear-gradient(45deg, #ff6ec4, #7873f5);
      color: #fff;
    }
    .age19 {
      background: linear-gradient(45deg, #00f2fe, #4facfe);
      color: #000;
    }
    .age30 {
      background: linear-gradient(45deg, #43e97b, #38f9d7);
      color: #000;
    }
    .age50 {
      background: linear-gradient(45deg, #f7971e, #ffd200);
      color: #222;
    }

    .article {
      background: rgba(255,255,255,0.06);
      border: 1px solid #ffe066;
      padding: 35px;
      border-radius: 16px;
      backdrop-filter: blur(10px);
      animation: fadeIn 1.2s ease-in-out;
      margin-top: 70px;
      color: #fff;
      box-shadow: 0 4px 30px rgba(0,0,0,0.3);
    }

    .bottom-btn {
      position: fixed;
      bottom: 20px;
      left: 50%;
      transform: translateX(-50%);
      background: linear-gradient(45deg, #00ff99, #00ccff);
      color: #000;
      padding: 14px 28px;
      font-weight: bold;
      border-radius: 30px;
      text-decoration: none;
      box-shadow: 0 0 20px rgba(0,255,255,0.6);
      z-index: 1001;
      transition: 0.3s ease;
    }
    .bottom-btn:hover {
      transform: translateX(-50%) scale(1.07);
      background: linear-gradient(45deg, #00e6e6, #00ffaa);
      box-shadow: 0 0 25px rgba(0,255,255,0.9);
    }

    #scrollTopBtn {
      position: fixed;
      bottom: 80px;
      right: 20px;
      background-color: #ffe066;
      color: #000;
      border: none;
      padding: 10px 14px;
      border-radius: 50%;
      font-size: 18px;
      cursor: pointer;
      display: none;
      z-index: 1002;
      box-shadow: 0 0 12px rgba(255,255,255,0.3);
    }

    @media (max-width: 600px) {
      header h1 {
        font-size: 20px;
      }
      .container, .article {
        padding: 20px;
      }
      .bottom-btn {
        width: 90%;
        text-align: center;
      }
    }
  </style>
</head>
<body>

  <header>
    <h1>Math Quiz</h1>
  </header>
  
  
  
  
  
   

  
  
  
  
  

  <div class="container">

    <div class="age-box">
      <h2>Select Your Age Range</h2>
      <p>Choose the age group that best describes you:</p>
      <div class="buttons">
        <a href="game" class="btn age13">13–18 🎉</a>
        <a href="game" class="btn age19">19–29 🚀</a>
        <a href="game" class="btn age30">30–50 👨‍💼</a>
        <a href="game" class="btn age50">50+ 🧓</a>
      </div>
    </div>
    
    
    
      
    
    

    <div class="article" id="info">
      <h3>🧭 The Ultimate Guide to Free Loan & Insurance Advice in the USA, Canada, and Australia</h3>
        <p>Feeling lost when it comes to loans or insurance? You’re not alone. Here’s how to make smarter financial choices with free expert help in your country.</p>
  </header>

  <nav>
    <h2>🔗 Table of Contents</h2>
    <ul>
      <li><a href="#why-free-advice">Why Free Financial Advice Matters</a></li>
      <li><a href="#loan-advice">Free Loan Advisory Services</a></li>
      <li><a href="#insurance-advice">Free Insurance Guidance</a></li>
      <li><a href="#benefits">Benefits of Using These Services</a></li>
      <li><a href="#tips">Quick Tips Before You Start</a></li>
      <li><a href="#faq">FAQs</a></li>
      <li><a href="#final-thoughts">Final Thoughts</a></li>
    </ul>
  </nav>

  <section id="why-free-advice">
    <h2>💰 Why Free Financial Advice Matters More Than Ever</h2>
    <p>Without expert guidance, it’s easy to fall into debt traps, underinsurance, or high-cost policies. Free advisory services—offered by banks, nonprofits, and government platforms—help you avoid that risk with tailored, no-cost support.</p>
  </section>

  <section id="loan-advice">
    <h2>🏦 Smarter Borrowing: Free Loan Advisory Services</h2>

    <h3>🇺🇸 USA</h3>
    <ul>
      <li><strong>Bank of America</strong> – Loan calculators and in-person advisors.</li>
      <li><strong>SoFi</strong> – Personal, student, and home loan consultations.</li>
      <li><strong>NFCC</strong> – Non-profit guidance for credit and debt management.</li>
    </ul>

    <h3>🇨🇦 Canada</h3>
    <ul>
      <li><strong>RBC & TD Bank</strong> – Mortgage and personal loan help.</li>
      <li><strong>Credit Canada</strong> – Budgeting and loan counseling.</li>
      <li><strong>BMO</strong> – Financial help for newcomers and young adults.</li>
    </ul>

    <h3>🇦🇺 Australia</h3>
    <ul>
      <li><strong>NAB</strong> – Borrowing calculators and free reviews.</li>
      <li><strong>Aussie Home Loans</strong> – Expert mortgage comparisons.</li>
      <li><strong>MoneySmart</strong> – Government-backed tools for loans.</li>
    </ul>
  </section>

  <section id="insurance-advice">
    <h2>🛡️ Insurance Made Simple: Free Guidance by Country</h2>

    <h3>🇺🇸 USA</h3>
    <ul>
      <li><strong>Policygenius</strong> – Compare life, auto, and renters insurance.</li>
      <li><strong>GEICO</strong> – Virtual insurance advice tools.</li>
      <li><strong>State Farm</strong> – Local and online insurance agents.</li>
    </ul>

    <h3>🇨🇦 Canada</h3>
    <ul>
      <li><strong>Manulife & Sun Life</strong> – Licensed agents with free support.</li>
      <li><strong>Canada Life</strong> – Digital insurance consultations.</li>
      <li><strong>Kanetix</strong> – Compare and choose the right policy online.</li>
    </ul>

    <h3>🇦🇺 Australia</h3>
    <ul>
      <li><strong>iSelect</strong> – Help with car, health, and travel insurance.</li>
      <li><strong>Allianz Australia</strong> – Live chat with insurance advisors.</li>
      <li><strong>CHOICE Australia</strong> – Independent insurance comparisons.</li>
    </ul>
  </section>

  <section id="benefits">
    <h2>🧠 Benefits of Using Free Advisory Services</h2>
    <ul>
      <li>🚫 Avoid scams, hidden fees, or bad deals</li>
      <li>✅ Make informed decisions with expert help</li>
      <li>💵 Save money and time with better plans</li>
      <li>🛡️ Get coverage that fits your budget and life</li>
    </ul>
  </section>

  <section id="tips">
    <h2>✅ Quick Tips Before You Start</h2>
    <ul>
      <li><strong>Know Your Needs</strong>: Be clear on what you want.</li>
      <li><strong>Compare Before You Commit</strong>: Use free tools to evaluate.</li>
      <li><strong>Verify Advisors</strong>: Ensure they’re licensed professionals.</li>
      <li><strong>Ask Questions</strong>: Get all terms explained clearly.</li>
    </ul>
  </section>

  <section id="faq">
    <h2>❓ Frequently Asked Questions</h2>

    <h3>Are free loan and insurance advisory services trustworthy?</h3>
    <p>Yes. Many are backed by the government, licensed nonprofits, and major banks.</p>

    <h3>Can I access these services online?</h3>
    <p>Yes, most offer support via websites, apps, or phone—some even provide live chat.</p>

    <h3>What’s the benefit of advisory help before choosing a loan?</h3>
    <p>They guide you on better rates, repayment plans, and hidden terms to avoid.</p>

    <h3>How do I know if an advisor is certified?</h3>
    <p>Look for licensed status, official affiliations, or government recognition.</p>

    <h3>Are comparison platforms safe to use?</h3>
    <p>Yes—especially when platforms like Policygenius or iSelect are involved.</p>
  </section>

  <section id="final-thoughts">
    <h2>📌 Final Thoughts</h2>
    <p>You don’t need to pay to get quality financial guidance. In the USA, Canada, and Australia, free services are helping people make smarter decisions on loans and insurance every day.</p>
    <p><strong>Before you sign that loan agreement or buy an insurance policy, explore these free options—you could save thousands and gain priceless peace of mind.</strong></p>
  </section>
    </div>

  </div>

  <a href="game" class="bottom-btn">Start Quiz 18+</a>
  <button id="scrollTopBtn" onclick="scrollToTop()">↑</button>

  <script>
    const scrollBtn = document.getElementById('scrollTopBtn');
    window.onscroll = () => {
      scrollBtn.style.display = window.scrollY > 300 ? 'block' : 'none';
    };
    function scrollToTop() {
      window.scrollTo({ top: 0, behavior: 'smooth' });
    }
  </script>
  
  
  <footer style="margin-top: 80px; padding: 30px 20px; text-align: center; background: rgba(255, 255, 255, 0.05); border-top: 1px solid #ffe066;">
    <p style="color: #ccc; font-size: 14px;">
      <a href="about" style="color: #ffe066; text-decoration: none; margin: 0 10px;">About Us</a> |
      <a href="termsandcondition" style="color: #ffe066; text-decoration: none; margin: 0 10px;">Terms & Conditions</a> |
      <a href="Privacy" style="color: #ffe066; text-decoration: none; margin: 0 10px;">Privacy Policy</a>
       <a href="Contact" style="color: #ffe066; text-decoration: none; margin: 0 10px;">Contact us</a>
    </p>
  </footer>
  
</body>

</html>